
***********************************************************************************************************
* FIGURE 3 - SCATTER PLOTS WITH V/U - QUARTERLY AND MONTHLY
************************************************************************************************************

* Figure 3.1. Quarterly

***************************************************************
* Read in data
***************************************************************

set more off
clear
* Put name of your main directory path here:
local main = "___"
cd `main'

use data_quarterly.dta, clear

***************************************************************
* Set color scheme (optional)
***************************************************************

set scheme s1color

***************************************************************
* Data work
***************************************************************

g sample1 = 1 if (t>=tq(1968q1)) & (t<=tq(1972q4))
g sample2 = 1 if (t>=tq(1973q1)) & (t<=tq(1984q4))
g sample3 = 1 if (t>=tq(1985q1)) & (t<=tq(2019q4))
g sample4 = 1 if (t>=tq(2020q1)) & (t<=tq(2022q3))

g sample13 = 1 if (sample1==1 | sample3==1)
g sample34 = 1 if (sample3==1 | sample4==1)

* Overall sample
keep if (t>=tq(1968q1)) & (t<=tq(2022q3))

***************************************************************
* Scatters: V/U
***************************************************************

* Define PC variables:
cap drop y x*
g y		= Median-pe
g x		= vu_4qa
g x2	= x^2
g x3	= x^3
local xtitle = "V/U (4-quarter average)"

//*
preserve
local index = 1
* No fitted lines
local title = "Quaterly Data"
twoway ///
(scatter y x if sample1==1, mcolor(emidblue) msymbol(D)) ///
(scatter y x if sample2==1, mcolor(eltblue) msymbol(O)) ///
(scatter y x if sample3==1, mcolor(blue*.6) msize(small) msymbol(Oh)) ///
(scatter y x if sample4==1, yline(0, lcolor(ebg)) mcolor(red)) ///
(line y x if sample4==1, lcolor(red) lpattern(dash)) ///
(scatter y x if sample4==1, mcolor(red) mlabel(t) mlabposition(12) mlabcolor(red) xtitle("`xtitle'") ytitle("Inflation gap") ///
legend(row(4) symxsize(4) ring(0) position(1) bmargin(none) region(style(none))) ///
legend(label(1 "1968-72") label(2 "1973-84") label(3 "1985-2019") label(4 "2020-22") order(1 2 3 4)) ///
xsize(4) ///
title("`title'", size(large)) ///
saving(`index'.gph, replace))
outsheet y x t using "results\charts\Figure 3 Quarterly.xls", replace
restore
*/	

* Figure 3.2. Monthly

***************************************************************
* Read in data
***************************************************************

set more off
clear
use data_monthly.dta, clear

***************************************************************
* Data work
***************************************************************

forval s = 1/4 {
	g sample`s' = 0
}
replace sample1 = 1 if (t>=tm(1968m1)) & (t<=tm(1972m12))
replace sample2 = 1 if (t>=tm(1973m1)) & (t<=tm(1984m12))
replace sample3 = 1 if (t>=tm(1985m1)) & (t<=tm(2019m12))
replace sample4 = 1 if (t>=tm(2020m1)) & (t<=tm(2022m9))

g sample13 = 1 if (sample1==1 | sample3==1)
g sample34 = 1 if (sample3==1 | sample4==1)

* Overall sample
keep if (t>=tm(1968m1)) & (t<=tm(2022m9))

***************************************************************
* Scatters: V/U
***************************************************************

* Define PC variables:
cap drop y x*
g y		= Median-pe
g x		= vu_12ma
g x2	= x^2
g x3	= x^3
local xtitle = "V/U (12-month average)"

//*
preserve
local index = 2
local title = "Monthly Data"
* No fitted lines
twoway ///
(scatter y x if sample1==1, yscale(range(-10 15)) ylabel(#8) mcolor(emidblue) msymbol(D)) ///
(scatter y x if sample2==1, mcolor(eltblue) msymbol(O)) ///
(scatter y x if sample3==1, mcolor(blue*.6) msize(small) msymbol(Oh)) ///
(scatter y x if sample4==1, yline(0, lcolor(ebg)) mcolor(red)) ///
(line y x if sample4==1, lcolor(red) lpattern(dash)) ///
(scatter y x if sample4==1, mcolor(red) mlabel(t) mlabposition(12) mlabcolor(red) xtitle("`xtitle'") ytitle("Inflation gap") ///
legend(row(4) symxsize(4) ring(0) position(1) bmargin(none) region(style(none))) ///
legend(label(1 "1968-72") label(2 "1973-84") label(3 "1985-2019") label(4 "2020-22") order(1 2 3 4)) ///
xsize(4) ///
title("`title'", size(large)) ///
saving(`index'.gph, replace))
outsheet y x t using "results\charts\Figure 3 Monthly.xls", replace
restore
*/	

graph combine 1.gph 2.gph, xsize(6)
